/*
 *  vvv.l - flex input file for scanning vhdl expressions
 *          and assignments.
 *
 *  Tom Mayo - 7-5-95
 */

%{

int my_vvvinput(char *b, int ms);

#undef YY_INPUT
#define YY_INPUT(b, r, ms)	(r = my_vvvinput(b, ms))

#include "b20.h"
#include "vvv.tab.h"

extern VVVSTYPE vvvlval;	/*	This is a structure from vvv.tab.h. */

%}

%%

state:	{ if (debug_exp)
	fprintf(stderr, "-- lexer: ok, starting a state string.\n");
	inputs_async = 0; /* not applicable anyway */
	outputs_async = 1;
	return(STATE_START); }

trans:	{ if (debug_exp)
	fprintf(stderr, "-- lexer: ok, starting a transition string.\n");
	inputs_async = 0;
	outputs_async = 0;
	return(TRANS_START); }

async:	{ if (debug_exp)
	fprintf(stderr, "-- lexer: ok, starting a async transition string.\n");
	inputs_async = 1;
	outputs_async = 0;
	return(ASYNC_START); }

\<\=	{ if (debug_exp)
	fprintf(stderr, "-- lexer: less-than-or-equal or assignment operator\n");
	return(FOO); }

\n	{ if (debug_exp)
	fprintf(stderr, "-- lexer: eol\n");
	mylineno++;
	return(EOL); }	/* End of line. */

[\r\t ]+	;	/* Dump whitespace. */

'[01]'|\"[01]+\"	{ if (debug_exp)
	fprintf(stderr, "-- lexer: literal\n");
	strncpy(vvvlval.sval, vvvtext, 128);
	return(LITERAL); }

and	{ if (debug_exp)
	fprintf(stderr, "-- lexer: and\n");
	return(AND); }

or	{ if (debug_exp)
	fprintf(stderr, "-- lexer: or\n");
	return(OR); }

nand	{ if (debug_exp)
	fprintf(stderr, "-- lexer: nand\n");
	return(NAND); }

nor	{ if (debug_exp)
	fprintf(stderr, "-- lexer: nor\n");
	return(NOR); }

xnor	{ if (debug_exp)
	fprintf(stderr, "-- lexer: xnor\n");
	return(XNOR); }

abs	{ if (debug_exp)
	fprintf(stderr, "-- lexer: abs\n");
	return(ABS); }

not	{ if (debug_exp)
	fprintf(stderr, "-- lexer: not\n");
	return(NOT); }

\*\*	{ if (debug_exp)
	fprintf(stderr, "-- lexer: exponent operator\n");
	return(EXPONENT_OPERATOR); }

[a-z][a-z0-9_]*	{ if (debug_exp)
	fprintf(stderr, "-- lexer: identifier \"%s\"\n", vvvtext);
	strncpy(vvvlval.sval, vvvtext, 128);
	return(IDENTIFIER); }

[0-9]* { if (debug_exp)
	fprintf(stderr, "-- lexer: number \"%s\"\n", vvvtext);
	vvvlval.ival = atoi(vvvtext);
	return(NUMBER); }

.	 { if (debug_exp)
	fprintf(stderr, "-- lexer: %c\n", vvvtext[0]);
	return(vvvtext[0]); }

%%

/*
 *  my_vvvinput - function to supply the lexer with
 *    a stream of VHDL input.
 */

int my_vvvinput(char *b, int ms)
{
	int n;
	
/*
 *  Set number of bytes to either the size of the buffer or the
 *  remaining bytes in the string, whichever is less.
 */
	n = (ms < vvv_lex_end - vvv_lex_ptr ?
		ms : vvv_lex_end - vvv_lex_ptr);

	if (debug_exp)
		fprintf(stderr, "-- Passing %d bytes to the lexer.\n", n);

	if (n > 0)
	{
		strncpy(b, vvv_lex_ptr, n);
		vvv_lex_ptr += n;
	}
	else
	{
		*vvv_lex_ptr = '\0';
	}

	return(n);
}
