/*
 *  brusey20.y - bison grammar for parsing a PIC input file
 *          to generate a behavioral VHDL description
 *          of a state machine diagram.
 *
 *  Tom Mayo - 6-15-95
 */

%{

#include "b20.h"

/*
 *  Declare global variables.
 */

int mylineno;
int prio;
int debug_parse, debug_fill, debug_exp, debug_iofind, debug_vhdl;
int sync_outputs, sync_reset, explicit_def;
transition_s_t *first_transition, *current_transition, *asynch_transition;
state_s_t *first_state, *current_state;
string_s_t *first_string, *current_string;
int states, strings, transitions;
char vvv_lex_string[LARGE_STRING], *vvv_lex_ptr, *vvv_lex_end;
int yydebug, vvvdebug;
io_s_t *first_in, *current_in;
io_s_t *first_out, *current_out;
int inputs_async;
int outputs_async;
char infilename[LARGE_STRING], outfilename[LARGE_STRING];
FILE *infp, *outfp;

char *version =
	"-- BRUSEY20 - PIC to VHDL Parser - v2.4\n"
	"-- Copyright (C) 1996 by Tom Mayo\n"
	"--\n"
	"-- To contact the author:  tcmayo@fang.berk.net\n"
	"--\n"
	"--                         Tom Mayo\n"
	"--                         106 S. Hemlock Ln.\n"
	"--                         Williamstown, MA  01267\n"
	"--\n"
	"-- This program is free software; you can redistribute it and/or modify\n"
	"-- it under the terms of version 2 of the GNU General Public License as\n"
	"-- published by the Free Software Foundation.\n"
	"--\n"
	"-- This program is distributed in the hope that it will be useful,\n"
	"-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
	"-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
	"-- GNU General Public License for more details.\n"
	"--\n"
	"-- You should have received a copy of the GNU General Public License\n"
	"-- along with this program; if not, write to the Free Software\n"
	"-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n"
	"--\n";

%}

/*
 *  The value returned by the lexer may be
 *  one of several things.
 */

%union {
	int		ival;
	double	dval;
	xy_s_t	xyval;
	char	sval[128];
}

/*
 *  Declare the tokens that the lexer will return
 *  to the parser.
 */

%token <ival> ARC CIRCLE LINE LEFT_ARROW RIGHT_ARROW CW AT FROM TO RAD
%token <ival> COMMA EOL RJUST LJUST FORMAT ENDQUOTE
%token <dval> NUMBER 
%token <sval> STRING

%type <xyval> xy

%%

/*  This is the most general object to be found.  */

input:	/* nothing */
	| input EOL
	| input arc
	| input circle
	| input line
	| input label
;

/*  Arcs => Transitions  */

arc: ARC RIGHT_ARROW AT xy FROM xy TO xy EOL
	{ fill_transition(arc_center(&$6, &$8, &$4, ARC_CCW), &$6, &$8); }
	| ARC LEFT_ARROW AT xy FROM xy TO xy EOL
	{ fill_transition(arc_center(&$8, &$6, &$4, ARC_CW), &$8, &$6); }
	| ARC RIGHT_ARROW AT xy FROM xy TO xy CW EOL
	{ fill_transition(arc_center(&$6, &$8, &$4, ARC_CW), &$6, &$8); }
	| ARC LEFT_ARROW AT xy FROM xy TO xy CW EOL
	{ fill_transition(arc_center(&$8, &$6, &$4, ARC_CCW), &$8, &$6); }
;

/*  Circles => States  */

circle: CIRCLE AT xy RAD NUMBER EOL
	{ fill_state(&$3, $5); }
;

/*  Lines => Transitions  */

line: LINE RIGHT_ARROW FROM xy TO xy EOL
	{ fill_transition(line_center(&$4, &$6), &$4, &$6); }
	| LINE LEFT_ARROW FROM xy TO xy EOL
	{ fill_transition(line_center(&$6, &$4), &$6, &$4); }
;

/*  Skip string formatting  */

formatting:	formatting FORMAT
	| FORMAT
	{ ; }
;

/*  Label => String Structure  */

label:	formatting STRING ENDQUOTE AT xy EOL
	{ fill_string(&$5, JUST_CENTER, $2); }
	| formatting STRING ENDQUOTE AT xy RJUST EOL
	{ fill_string(&$5, JUST_RIGHT, $2); }
	| formatting STRING ENDQUOTE AT xy LJUST EOL
	{ fill_string(&$5, JUST_LEFT, $2); }
;

/*  This is an x,y coordinate location.  */

xy:	NUMBER COMMA NUMBER
	{ $$.x = $1; $$.y = $3; }
;

%%

/*
 *  Now the actual execution code begins.
 */

extern FILE *yyin;

void main(int argc, char **argv)
{
	int argci;

	mylineno = 1;

	debug_parse =
		debug_fill =
		debug_exp =
		debug_iofind =
		debug_vhdl = 0;

	sync_outputs =
		sync_reset =
		explicit_def = 0;

	states =
		transitions =
		strings = 0;

#ifdef MY_YYDEBUG
	yydebug = 1;
#else
	yydebug = 0;
#endif

#ifdef MY_VVVDEBUG
	vvvdebug = 1;
#else
	vvvdebug = 0;
#endif

/*
 *  Check the command line for a debug switch.
 */
 	for (argci = 1; argci < argc; argci++)
	{
		if (argv[argci][0] == '-')
		{
			switch (argv[argci][1])
			{
			case 'l':
				preamble(stdout);
				exit(1);
				break;
			case 'd':
				switch (argv[argci][2])
				{
				case 'a':
					debug_parse =
						debug_fill =
						debug_exp =
						debug_iofind =
						debug_vhdl = 1;
					break;
				case 'p':
					debug_parse = 1;
					break;
				case 'f':
					debug_fill = 1;
					break;
				case 'e':
					debug_exp = 1;
					break;
				case 'i':
					debug_iofind = 1;
					break;
				case 'v':
					debug_vhdl = 1;
					break;
				default:
					usage();
					break;
				}
				break;
			case 'h':
				usage();
				break;
			case 's':
				switch (argv[argci][2])
				{
				case 'o':
					sync_outputs = 1;
					break;
				case 'r':
					sync_reset = 1;
					break;
				default:
					usage();
					break;
				}
			case 'v':
				switch (argv[argci][2])
				{
				case 'e':
					explicit_def = 1;
					break;
				default:
					usage();
					break;
				}
				break;
			case 'i':
				if (argv[argci][2] == '=')
				{
					strcpy(infilename, &(argv[argci][3]));
					if ((infp = fopen(infilename, "r")) == (FILE *)NULL)
					{
						usage();
					}
				}
				else
				{
					usage();
				}
				break;
			case 'o':
				if (argv[argci][2] == '=')
				{
					strcpy(outfilename, &(argv[argci][3]));
					if ((outfp = fopen(outfilename, "w")) == (FILE *)NULL)
					{
						usage();
					}
				}
				else
				{
					usage();
				}
				break;
			default:
				usage();
				break;
			}
		}
		else
		{
			usage();
		}
	}

	preamble(stderr);
	
/*
 *  Call the parser (which calls the lexer).
 */

	if (debug_parse)
	 	fprintf(stderr, "-- Parsing PIC file...\n");
	
	yyin = infp;

	do
	{
		yyparse();
	}
	while(!feof(yyin));

/*
 *  Report what was found in the input.
 */
	if (debug_parse)
		fprintf(stderr, "-- %d states, %d transitions, %d strings.\n",
			states, transitions, strings);

/*
 *  Flesh out the data base.
 */
 	if (debug_fill)
	 	fprintf(stderr, "-- Filling data structures...\n");

	b20fill();

/*
 *  Identify all inputs and outputs.
 */
 	if (debug_iofind)
	 	fprintf(stderr, "-- Finding inputs and outputs...\n");

 	b20iofind();

/*
 *  Generate VHDL code.
 */
 	if (debug_vhdl)
	 	fprintf(stderr, "-- Generating VHDL...\n");

 	b20trav();

	exit(0);
}

/*
 *  Rudimentary error reporting.  This could be better.
 */

void yyerror(char *s)
{
	extern char *yytext;
	extern int mylineno;

	fprintf(stderr, "-- %s near \"%s\" on line %d.\n",
		s, yytext, mylineno);
}
