
func patch_netlist(string des) {
  println Patching netlist (cat @des ".edif") "-> tmp.edif"
  sh sed -f "$S2M/patch.sed" "<" (cat @des ".edif") ">" tmp.edif
  println Reading "auxlib.edif"
  rd_edif "$S2M/auxlib.edif"
  println Fixing auxilliary library
  fixaux
  setext GEN_LIB
}

func read_netlist(string des) {
  println Reading (cat @des ".edif")
  rd_edif (cat @des ".edif")
}

func convert_design (
  string des
  string lib_name
  string mgc_symbol_path
) {
  println Fixing @lib_name library
  fixlibrary @lib_name @mgc_symbol_path
  println Checking for unconnected ports
  fixcells
  setext @lib_name
  sel "" DESIGNS @des NETLIST_REPRESENTATION
  println Writing EDDM netlist to @des
  wr_eddm @des @Netlist '((sg_no_leaf) (viewpoint_path @des ) \
  (model_prop_dofile "dve.do") (model_prop_sg TRUE) (eddm_model "$schematic"))
  sel ""
}

func fixcells {
  abstract cell c1
  abstract view v1
  abstract instance p1
  foreach c1 (cells (findlibrary DESIGNS)) {
    if ((substr @c1._name 0 1) != "$") {
      if (((lower @c1._name) != "logic_xx") && \
          ((lower @c1._name) != "logic_yy")) {
       c1._name = (lower @c1._name)
       c1._rename = (lower @c1._rename)
       println Fixing cell @c1._name
       foreach v1 (views @c1) {
         patchnc @v1._netlist
         v1.syn_interface = @c1._name
         v1.syn_eddm_path = @c1._name
       }
      }
    }
  }
}


func fixlibrary (
   string lib_name
   string symbol_path
)  {
  abstract cell c1
  abstract view v1
  abstract instance p1
  string oldname
  foreach c1 (cells (findlibrary @lib_name)) {
    oldname = @c1._name
    if ((substr @c1._name 0 1) != "$")  {
      println Fixing cell @c1._name
      foreach v1 (views @c1) {
	v1.syn_eddm_path = (cat @symbol_path (lower @c1._name))
	v1.syn_interface = (lower @c1._name)
      }
      c1._name = (cat @symbol_path (lower @c1._name))
      c1._rename = @c1._name
      println Renaming cell @oldname " -> " @c1._name
    }
  }
}

func setext  (string lib_name) {
  abstract cell c1
  abstract view v1
  abstract instance p1 
  foreach c1 (cells (findlibrary @lib_name)) {
    foreach v1 (views @c1) { 
      v1._external = 1
      println Checking cell @c1._name
    }
  }
}

func fixaux  {
  abstract cell c1
  abstract view v1
  abstract instance p1
  string oldname
  foreach c1 (cells (findlibrary GEN_LIB)) {
    oldname = @c1._name
    if ((substr @c1._name 0 1) != "$")  {
      foreach v1 (views @c1) {
        v1.syn_eddm_path = (cat "$MGC_GENLIB/" (lower @c1._name))
        v1.syn_interface = (lower @c1._name)
      }
      c1._name = (cat "$MGC_GENLIB/" (lower @c1._name))
      c1._rename = @c1._name
      println Renaming cell @oldname " -> " @c1._name
    }
  }
}

