----------------------------------------------------------------------------  
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  rgrce.10.004.ac.on.002.vhdl
--   Title     :  IEEE Std 1076-1987 Language Reference Manual test
--   Purpose   :  Check that a declarative region is formed by the text of:
--                "A configuration declaration."
--   Author(s) :  DBB
--   Notes     :  Do this by putting a non-imported symbol in configuration
----------------------------------------------------------------------------   

-- a nand gate
entity ENT1 is
    port ( BITIN1, BITIN2 : in  BIT;
           BITOUT: out BIT );
end ENT1;

architecture ARC1 of ENT1 is
begin
    BITOUT <= ( BITIN1 nand BITIN2 ) after 1ns;
end ARC1;

configuration CON1 of ENT1 is
    for ARC1
    end for;
end CON1;

-- build an inverter from nand-nand logic
entity ENT2 is
    port ( GOING_IN: in BIT;
           COMING_OUT: out BIT );
end ENT2;

architecture ARC2 of ENT2 is
    component NAND_BOX 
        port ( IN1, IN2: in BIT; OUT1: out BIT );
    end component;
    signal STUCKAT_HIGH: BIT := '1';
begin
    NAND_COMP: NAND_BOX port map ( GOING_IN, STUCKAT_HIGH, COMING_OUT );
end ARC2;

-- omitting "use WORK.CON1;" here causes the error
configuration CON2 of ENT2 is
    for ARC2
        for NAND_COMP: NAND_BOX
-- ERROR: "CON1" is unknown here
            use configuration CON1
                port map ( GOING_IN, STUCKAT_HIGH, COMING_OUT );
        end for;
    end for;
end CON2;

