
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e9.40.it.et.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that it is an error if the target of a concurrent signal
--                assignment statement is neither a guarded target nor an unguarded
--                target.
--
--   Author(s) :  KES          
--
--   Remarks   :  This can only be true when we do an aggregate signal assignment
--                in which there are guarded and non-guarded signals appearing in
--                the aggregate target of the assignment.
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is
    -- Declare a type.
    type HALF_NIBBLE is array( 0 to 1 ) of BIT;

    -- Define resolution function and subtype.
    function Wired_Or( S : BIT_VECTOR ) return BIT is
    begin
        for I in S'Range loop
            if  (S(I) = '1') then
                return '1';
            end if;
        end loop;
        return '0';
    end Wired_Or;
    subtype RBIT is Wired_Or BIT;

    -- Global signals.
    SIGNAL Guardd     : RBIT bus;
    SIGNAL NotGuarded : RBIT;

begin

    -- This performs the assignment.  This should be an error.
    GUARD1:        block
                   begin
--                       ( Guardd, NotGuarded ) <= HALF_NIBBLE'( 0 => RBIT'('1'),1 => RBIT'('1') );
                       ( Guardd, NotGuarded ) <= HALF_NIBBLE'( 0 => RBIT'( '1' ),1 => RBIT'( '1' ) );
                   end block GUARD1;


end TEST_BEHAVIOR;


