
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e9.38.it.et.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that it is an error if the target of a concurrent
--                signal assignment is neither a guarded target nor an un-
--                guarded target.
--
--   Author(s) :  KES          
--
--   Remarks   :  This means that the target must be in the form of an 
--                aggregate AND at least one of the signals contained
--                therein is a guarded signal and at least one is not.
--
-- ---------------------------------------------------------------------------

package TEST_PACK is
   function RESFUNC( S : BIT_VECTOR ) return BIT;
   subtype RBIT is RESFUNC BIT;
   subtype BIT2 is BIT_VECTOR( 0 to 1 );

end TEST_PACK;
------------------------------------------------------------------------

use work.TEST_PACK.all;
entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is
    -- Global signals.
    SIGNAL B1      : RBIT bus;
    SIGNAL B2      : BIT;

begin

    GUARD1:        block( TRUE )
                   begin
                       ( B1, B2 ) <= guarded BIT2'( B1, B2 ) after 10 ns;  -- ERROR:
                   end block GUARD1;

end TEST_BEHAVIOR;
