
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e9.16.su.on.1.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that all 'not-passive' processes, as defined in this 
--                paragraph, may NOT appear in the entity statement part of an  
--                entity declaration.
--
--   Author(s) :  KES          
--
--   Remarks   :  All possible types of illegal non-passive processes.
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

    -- Port declarations.
    port( signal S : OUT BIT );

    -- Local procedure.
    procedure proccall;
    procedure proccall is
    begin
        S <= '1' after 10ns;
    end;

begin
    -- Try a direct signal assignment.   ERROR:
    S <= '1' after 10ns;

    -- Try a non-passive concurrent procedure call.  ERROR:
    proccall;

    -- Try a non-passive process statement.  ERROR:
    process
    begin
        S <= '1' after 10ns;
    end process;

end TEST;

------------------------------------------------------------------------

