
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e9.13.on.nt.1.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that non-statically indexed signal names may NOT be
--                used in the sensitivity_list of a process statement.
--                All process-statements in this file should cause VHDL compilation
--                errors.
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

-- Define this package for the types to be used in our tests.
package TEST_PACK is

   -- Type declarations.
   type    SWITCH_LEVEL   is ( '0', '1', 'X' );
   type    S_logic_vector is array(positive range <>) of SWITCH_LEVEL;

   -- Define the bus resolution function.
   function switchf( s : S_logic_vector ) return SWITCH_LEVEL;

   -- Further type declarations.
   subtype SWITCH_T       is switchF SWITCH_LEVEL;
   type    WORD           is array(0 to 31) of SWITCH_T;

end TEST_PACK;

package body TEST_PACK is

function switchf( s : S_logic_vector ) return SWITCH_T is

begin
    return( S(1) );
end switchf;

end TEST_PACK;



------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------

use work.TEST_PACK.all;    
architecture TEST_BEHAVIOR of TEST is
    type     SWORD is   ARRAY( 0 to 31 ) of SWITCH_LEVEL;
    signal   A        : WORD;
    signal UnResolved : SWORD;
    signal   Index    : INTEGER;

begin

    TEST_PROCESS:  process( A( Index ), Unresolved( Index ) )   -- ERROR:

                   begin
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
