
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e9.06.th.ce.1.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Try illegally using the GUARD signal in a signal assignment
--                statement.
--
--   Author(s) :  KES          
--
--   Remarks   :  
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

    -- Component declaration.
    component COMP port( I : IN BOOLEAN );
    end component;
    component OUTCOMP port( G1 : OUT BOOLEAN );
    end component;
    component INOUTCOMP port( G1 : INOUT BOOLEAN );
    end component;
    component BUFFERCOMP port( G1 : BUFFER BOOLEAN );
    end component;
    component LINKAGECOMP port( G1 : LINKAGE BOOLEAN );
    end component;

begin

    TEST_BLOCK:  block( TRUE )
                 begin
                     -- 1. Illegal assignment to GUARD.
                     GUARD <= FALSE after 10ns;

                     -- 2. Illegal assignment within a sub-block.
                     BAD_BLOCK:      block
                                     begin
                                         GUARD <= FALSE after 10ns;
                                     end block BAD_BLOCK;

                     -- 3. Illegal assignment within a sub-process.
                     BAD_PROCESS:    process
                                     begin
                                         GUARD <= FALSE after 10ns;
                                     end process BAD_PROCESS;

                     -- 4. Illegal passing to ports of mode OUT, INOUT, BUFFER, LINKAGE.
                     OUT_BLOCK:      block
                                         port( G1    : OUT BOOLEAN );
                                         port map ( G1 => GUARD );
                                     begin
                                     end block OUT_BLOCK;

                     INOUT_BLOCK:    block
                                         port( G1    : INOUT BOOLEAN );
                                         port map ( G1 => GUARD );
                                     begin
                                     end block INOUT_BLOCK;

                     BUFFER_BLOCK:   block
                                         port( G1    : BUFFER BOOLEAN );
                                         port map ( G1 => GUARD );
                                     begin
                                     end block BUFFER_BLOCK;

                     LINKAGE_BLOCK:  block
                                         port( G1    : LINKAGE BOOLEAN );
                                         port map ( G1 => GUARD );
                                     begin
                                     end block LINKAGE_BLOCK;

                     -- 5. Illegal associating with ports in components of mode OUT,
                     --    INOUT, BUFFER, LINKAGE.
                     OUT_COMP:       OUTComp port map ( G1 => GUARD );

                     INOUT_COMP:     INOUTComp port map ( G1 => GUARD );

                     BUFFER_COMP:    BUFFERComp port map ( G1 => GUARD );

                     LINKAGE_COMP:   LINKAGEComp port map ( G1 => GUARD );

                 end block TEST_BLOCK;
end TEST_BEHAVIOR;
