
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e8.43.if.me.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that if the target of a variable assignment statement
--                is a name, then the name must denote a variable.
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is
    -- Component declarations.
    component CompA
    end component;


    -- Local signals.
    signal S       : BIT;

begin

    TEST_PROCESS:  process
                       -- A constant declaration.
                       CONSTANT CONSTBIT : BIT := '0';

                       -- A type declaration.
                       type    SWITCH_LEVEL is ('0', '1', 'X');
                       type FT is file of BIT;

                       -- A file declaration.
                       file FileV : FT is "input_file";

                       -- attribute declarations.
                       attribute LOCATION : BIT;


                   begin
                       -- Make invalid assignments to non-variables.
                       S            := '1';   -- a signal.  ERROR:
                       CONSTBIT     := '1';   -- a constant.  ERROR:
                       SWITCH_LEVEL := '1';   -- a type.  ERROR:
                       FILEV        := '1';   -- a file.  ERROR:
                       LOCATION     := '1';   -- an attribute.  ERROR:
                       CompA        := '1';   -- a component.  ERROR:
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;

