
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e8.10.it.am.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Make sure that it is an error if a wait statement appears in
--                a function subprogram.
--
--   Author(s) :  KES          
--
--   Remarks   :  The function 'hasWait' should cause the first such error.
--
-- ---------------------------------------------------------------------------

-- Define this package for the types to be used in our tests.
package TEST_PACK is
   -- Contains a wait statement.
   function  hasWait return BIT;

end TEST_PACK;

package body TEST_PACK is

-- Function contains wait statement:  ERROR.
function hasWait return BIT is
begin
    wait for 15ns;
    return( '0' );
end;

end TEST_PACK;



------------------------------------------------------------------------

entity TEST is

end TEST;

use work.TEST_PACK.all;
architecture TEST_BEHAVIOR of TEST is
    -- Local signals.
    signal A : BIT; 

begin

    TEST_PROCESS:  process
                   begin
                       -- Call function with a wait statement.
                       if  (hasWait = '0') then
                           null;
                       end if;

                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
