
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e8.03.th.re.2.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Test wait statements.
--                - Test illegal semantics in the sensitivity_clause.  These
--                  are:
--                  1) Empty sensitivity list.
--                  2) Undefined signal in sensitivity list.
--                  3) Variable in a sensitivity list.
--                  4) Output port in a sensitivity list.  (they are read-only)
--                  5) Same signal multiple times in the sensitivity list.
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

    port ( signal I         : in BIT;   --  input ports
           signal O         :out BIT ); -- output ports

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

begin

    TEST_PROCESS:  process
                       -- Local declarations.
                       variable j      : integer;

                   begin
                       -- 1. Empty sensitivity list.
                       wait on ;

                       -- 2. Undefined signal in sensitivity list.
                       wait on ii;
 
                       -- 3. Variable in a sensitivity list.
                       wait on j;

                       -- 4. Output port in sensitivity list.
                       wait on O;

                       -- 5. Same signal multiple times.  (maybe a warning)
                       wait on I, I, I;

                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;