
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e8.03.th.re.1.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Test wait statements.
--                - If any of the clause keywords in the WAIT statement are
--                  misspelled, a helpful error message should be output by
--                  the VHDL compiler.
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

    port ( signal I         : in BIT;   --  input ports
           signal O         :out BIT ); -- output ports

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

begin

    TEST_PROCESS:  process
                       -- Local declarations.
                       variable j      : integer;

                   begin
                       -- Misspelling ON.  ERROR:
                       wait no i;

                       -- Misspelling UNTIL.  ERROR:
                       wait on i untli (i = '1');

                       -- Misspelling FOR.  ERROR:
                       wait on i until (i = '1') ofr 60ns;

                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
