
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e7.43.th.er.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that the only types for which exponentiation is
--                predefined are the types INTEGER and REAL.  In addition,
--                verify that the only legal type for the exponent is of
--                type INTEGER.  All expressions within the process should
--                result in a VHDL compilation error.
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

begin

    TEST_PROCESS:  process
                       -- All different non-numeric type declarations.
                       -- enumerated types.
                       type    SWITCH_LEVEL is ('0', '1', 'X');
                       subtype LOGIC_SWITCH is SWITCH_LEVEL range '0' to '1';

                       -- array types.
                       type MEMORY is array(INTEGER range <>) of BIT;
                       type WORD   is array(0 to 31) of BIT;
                       type BYTE   is array(7 downto 0) of BIT;

                       -- record types.
                       type DATE is
                           record
                              DAY           : INTEGER range 1 to 31;
                              MONTH         : INTEGER range 1 to 12;
                              YEAR          : INTEGER range -10000 to 1988;
                           end record;

                       -- access types.
                       type ADDRESS  is access MEMORY;
                       type WORDPTR  is access WORD;

                       -- file types.
                       type FT is file of BIT;

                       -- Local declarations.
                       variable SWITCHV  : SWITCH_LEVEL := '0';
                       variable LOGICV   : LOGIC_SWITCH := '0';
                       variable CHARV    : CHARACTER    := '0';
                       variable BITV     : BIT          := '0';
                       variable BOOLV    : BOOLEAN      := FALSE;
                       variable SEVERV   : SEVERITY_LEVEL := NOTE;
                       variable MEMORYV  : MEMORY( 0 to 31 );
                       variable WORDV    : WORD;
                       variable BYTEV    : BYTE;
                       variable STRINGV  : STRING( 1 to 8 );
                       variable BITSTRV  : BIT_VECTOR( 0 to 7 );
                       variable RECV     : DATE;
                       variable ADDRESSV : ADDRESS;
                       variable WORDPTRV : WORDPTR;
                       variable INTV     : INTEGER;
                       variable REALV    : REAL;
                       file     FILEV    : FT is "input_file";

                   begin
                       -- Test illegal types for the first argument to the ** function.
                       INTV     := SWITCHV ** 2;   -- ERROR:
                       INTV     := LOGICV ** 2;    -- ERROR:
                       INTV     := CHARV ** 2;     -- ERROR:
                       INTV     := BITV ** 2;      -- ERROR:
                       INTV     := SEVERV ** 2;    -- ERROR:
                       INTV     := MEMORYV ** 2;   -- ERROR:
                       INTV     := WORDV ** 2;     -- ERROR:
                       INTV     := BYTEV ** 2;     -- ERROR:
                       INTV     := STRINGV ** 2;   -- ERROR:
                       INTV     := BITSTRV ** 2;   -- ERROR:
                       INTV     := RECV ** 2;      -- ERROR:
                       INTV     := ADDRESSV ** 2;  -- ERROR:
                       INTV     := WORDPTRV ** 2;  -- ERROR:
                       INTV     := FILEV ** 2;     -- ERROR:

                       -- Test illegal types for the second argument to the ** function.
                       INTV     := 2 ** SWITCHV;   -- ERROR:
                       INTV     := 2 ** LOGICV;    -- ERROR:
                       INTV     := 2 ** CHARV;     -- ERROR:
                       INTV     := 2 ** BITV;      -- ERROR:
                       INTV     := 2 ** SEVERV;    -- ERROR:
                       INTV     := 2 ** MEMORYV;   -- ERROR:
                       INTV     := 2 ** WORDV;     -- ERROR:
                       INTV     := 2 ** BYTEV;     -- ERROR:
                       INTV     := 2 ** STRINGV;   -- ERROR:
                       INTV     := 2 ** BITSTRV;   -- ERROR:
                       INTV     := 2 ** RECV;      -- ERROR:
                       INTV     := 2 ** ADDRESSV;  -- ERROR:
                       INTV     := 2 ** WORDPTRV;  -- ERROR:
                       INTV     := 2 ** FILEV;     -- ERROR:
                       INTV     := 2 ** REALV;     -- ERROR:

                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
