
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e7.42.th.pe.1.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that the only types for which the ABS function is
--                predefined are the numeric types.  Do this by attempting
--                to apply the function to all other possible types.
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

begin

    TEST_PROCESS:  process
                       -- All different non-numeric type declarations.
                       -- enumerated types.
                       type    SWITCH_LEVEL is ('0', '1', 'X');
                       subtype LOGIC_SWITCH is SWITCH_LEVEL range '0' to '1';

                       -- array types.
                       type MEMORY is array(INTEGER range <>) of BIT;
                       type WORD   is array(0 to 31) of BIT;
                       type BYTE   is array(7 downto 0) of BIT;

                       -- record types.
                       type DATE is
                           record
                              DAY           : INTEGER range 1 to 31;
                              MONTH         : INTEGER range 1 to 12;
                              YEAR          : INTEGER range -10000 to 1988;
                           end record;

                       -- access types.
                       type ADDRESS  is access MEMORY;
                       type WORDPTR  is access WORD;

                       -- file types.
                       type FT is file of BIT;

                       -- Local declarations.
                       variable SWITCHV  : SWITCH_LEVEL := '0';
                       variable LOGICV   : LOGIC_SWITCH := '0';
                       variable CHARV    : CHARACTER    := '0';
                       variable BITV     : BIT          := '0';
                       variable BOOLV    : BOOLEAN      := FALSE;
                       variable SEVERV   : SEVERITY_LEVEL := NOTE;
                       variable MEMORYV  : MEMORY( 0 to 31 );
                       variable WORDV    : WORD;
                       variable BYTEV    : BYTE;
                       variable STRINGV  : STRING( 1 to 9 );
                       variable BITSTRV  : BIT_VECTOR( 0 to 7 );
                       variable RECV     : DATE;
                       variable ADDRESSV : ADDRESS;
                       variable WORDPTRV : WORDPTR;
                       file     FILEV    : FT is "input_file";

                   begin
                       -- Apply function to all illegal types.
                       SWITCHV  := ABS SWITCHV;    -- BEGIN ERRORS:
                       LOGICV   := ABS LOGICV;
                       CHARV    := ABS CHARV;
                       BITV     := ABS BITV;
                       SEVERV   := ABS SEVERV;
                       MEMORYV  := ABS MEMORYV;
                       WORDV    := ABS WORDV;
                       BYTEV    := ABS BYTEV;
                       STRINGV  := ABS STRINGV;
                       BITSTRV  := ABS BITSTRV;
                       RECV     := ABS RECV;
                       ADDRESSV := ABS ADDRESSV;
                       WORDPTRV := ABS WORDPTRV;
                       FILEV    := ABS FILEV;      -- END ERRORS:
                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
