
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e7.39.di.on.2.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that the division of a physical type by an integer constant
--                of zero gets detected either by the analyzer or by the simulator.
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

begin

    TEST_PROCESS:  process
                       -- integer types.
                       type POSITIVE        is range 0 to INTEGER'HIGH;

                       -- user defined physical types.
                       type DISTANCE is range 0 to 1E9
                           units
                               -- Base units.
                               A;                    -- angstrom
 
                               -- Metric lengths.
                               nm       = 10 A;      -- nanometer
                               um       = 1000 nm;   -- micrometer (or micron)
                               mm       = 1000 um;   -- millimeter
                               cm       = 10 mm;     -- centimeter
 
                               -- English lengths.
                               mil      = 254000 A;  -- mil
                               inch     = 1000 mil;  -- inch
                           end units;

                       -- Local declarations.
                       variable INTV    : INTEGER;
                       variable POSV    : POSITIVE;
                       variable DISTV   : DISTANCE;
                       variable TIMEV   : TIME;

                   begin
                       -- Should be some errors detected on these lines.
                       assert ((1cm / 0) = 1cm);
                       assert ((1sec / 0) = 1sec);

                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;



configuration BETA of TEST is
    for TEST_BEHAVIOR
    end for;
end BETA;
