
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e7.32.th.ng.3.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that the operators "*" and "/" detect when their boundaries
--                have been passed.  All statements in this file should result
--                in simulation run-time errors detected by the simulation kernel.
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

begin

    TEST_PROCESS:  process
                       -- All different type declarations.
                       -- integer types.
                       type POSITIVE        is range 0 to INTEGER'HIGH;

                       -- floating point types.
                       type POSITIVE_R    is range 0.0 to REAL'HIGH;

                       -- Local declarations.
                       variable INTV    : INTEGER      := 0;
                       variable POSV    : POSITIVE     := 0;
                       variable REALV   : REAL         := 0.0;
                       variable POSRV   : POSITIVE_R   := 0.0;


                   begin
                       -- Test integer overflow/underflow.
                       INTV := INTEGER'HIGH * 2;
                       INTV := INTEGER'LOW * 2;

                       -- Test constrained integer overflow/underflow.
                       POSV := POSITIVE'HIGH * 2;
                       POSV := POSITIVE'LOW  * (-1);

                       -- Test integer division overflow/underflow.
                       INTV := INTEGER'HIGH / 0;
                       POSV := POSITIVE'HIGH / 0;
                       POSV := POSITIVE'HIGH / (-1);

                       -- Test floating point overflow/underflow.
                       REALV := REAL'HIGH * 2.0;
                       REALV := REAL'LOW * 2.0;

                       -- Test constrained floating point overflow/underflow.
                       POSRV := POSITIVE_R'HIGH * 2.0;
                       POSRV := POSITIVE_R'LOW  * (-1.0);

                       -- Test floating point division overflow/underflow.
                       REALV := REAL'HIGH / 0.0;
                       POSRV := POSITIVE_R'HIGH / 0.0;
                       POSRV := POSITIVE_R'HIGH / (-1.0);

                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
