
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e7.30.be.ot.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that the signals "+" and "-" may not follow a
--                multiplying operator, the exponentiating operator **, or 
--                operators abs and not.  All statements within the
--                process here should result in an error.
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

begin

    TEST_PROCESS:  process

                       -- local variables
                       variable J : INTEGER;
                       variable R : REAL;

                   begin
                       -- Multiplying operators.
                       J := 4 * -3;       -- ERROR:
                       J := 4 / -3;       -- ERROR:
                       J := 4 mod -3;     -- ERROR:
                       J := 4 rem -3;     -- ERROR:

                       -- Exponentiation operator.
                       R := 4.0 ** -3;    -- ERROR:

                       -- Absolute value operator.
                       J := abs -3;       -- ERROR:

                       -- Not operator.
                       J := NOT - 3;      -- ERROR:

                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
