
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e7.24.th.ng.1.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that the operators "+" and "-" are not predefined for 
--                all non-numeric types.  Every such expression should result
--                in an error reported by the compiler.
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

begin

    TEST_PROCESS:  process
                       -- All different non-numeric type declarations.
                       -- enumerated types.
                       type    SWITCH_LEVEL is ('0', '1', 'X');
                       subtype LOGIC_SWITCH is SWITCH_LEVEL range '0' to '1';

                       -- array types.
                       type MEMORY is array(INTEGER range <>) of BIT;
                       type WORD   is array(0 to 31) of BIT;
                       type BYTE   is array(7 downto 0) of BIT;

                       -- record types.
                       type DATE is
                           record
                              DAY           : INTEGER range 1 to 31;
                              MONTH         : INTEGER range 1 to 12;
                              YEAR          : INTEGER range -10000 to 1988;
                           end record;

                       -- access types.
                       type ADDRESS  is access MEMORY;
                       type WORDPTR  is access WORD;

                       -- file types.
                       type FT is file of BIT;

                       -- Local declarations.
                       variable SWITCHV : SWITCH_LEVEL := '0';
                       variable LOGICV  : LOGIC_SWITCH := '0';
                       variable CHARV   : CHARACTER    := '0';
                       variable BITV    : BIT          := '0';
                       variable BOOLV   : BOOLEAN      := FALSE;
                       variable SEVERV  : SEVERITY_LEVEL := NOTE;
                       variable MEMORYV : MEMORY( 0 to 31 );
                       variable WORDV, WORD2V   : WORD;
                       variable BYTEV   : BYTE;
                       variable STRINGV : STRING( 1 to 8 );
                       variable BITSTRV : BIT_VECTOR( 0 to 8 );
                       variable RECV    : DATE;
                       variable ADDRESSV: ADDRESS;
                       variable WORDPTRV,
                                WORDPTR2V: WORDPTR;
                       file     FILEV   : FT is "input_file";
                       variable Temp    : BOOLEAN;

                   begin
                       -- Verify that enumerated types may not be added or subtracted.
                       assert ((SWITCHV + '1') = '0');
                       assert ((LOGICV + SWITCHV) = '0');
                       assert ((LOGICV + '0') = '1');
                       assert ((SWITCHV - '1') = '0');
                       assert ((LOGICV - SWITCHV) = '0');
                       assert ((LOGICV - '0') = '1');

                       -- Same for character types.
                       assert ((NUL + CHARV) = CHARV);
                       assert (('0' + '2') = '2');
                       assert ((NUL - CHARV) = CHARV);
                       assert (('0' - '2') = '2');

                       -- Same for bit-types.
                       assert ((BITV + BITV) = '1');
                       assert ((BITV + '1') = '1');
                       assert ((BITV - '0') = BITV);
                       assert ((BITV - '1') = '0');

                       -- Same for boolean types.
                       assert ((BOOLV + BOOLV) = TRUE);
                       assert ((BOOLV + TRUE) = TRUE);
                       assert ((BOOLV - FALSE) = BOOLV);
                       assert ((BOOLV - TRUE) = FALSE);

                       -- Same for SEVERITY_LEVEL types.
                       assert ((SEVERV + SEVERV) = WARNING);
                       assert ((SEVERV + WARNING) = WARNING);
                       assert ((SEVERV - NOTE) = SEVERV);
                       assert ((SEVERV - WARNING) = NOTE);

                       -- Test array types now.
                       assert ((MEMORYV + MEMORYV) = MEMORYV);
                       assert ((WORDV - WORDV) = WORDV);
                       assert ((BYTEV - BYTEV) = BYTEV);

                       -- Test string types.
                       assert ((STRINGV + "hello, world") = "bust");
                       assert (("goodbye, world" + "hello, world") = "bust");
                       assert ((STRINGV - "hello, world") = "bust");
                       assert (("goodbye, world" - "hello, world") = "bust");

                       -- Bit vector types.
                       assert ((BITSTRV + X"7777") = O"1313");
                       assert ((B"1010101010" + X"FFFF") = O"7777");
                       assert ((BITSTRV - X"7777") = O"1313");
                       assert ((B"1010101010" - X"FFFF") = O"7777");

                       -- Record types.
                       assert ((RECV + ( DAY => 14, MONTH => 2, YEAR => 1988 )) = RECV);
                       assert ((RECV - ( DAY => 14, MONTH => 2, YEAR => 1988 )) = RECV);

                       -- Access types.
                       assert ((ADDRESSV + NULL) = ADDRESSV);
                       assert ((WORDPTRV + WORDPTR2V) = NULL);
                       assert ((ADDRESSV - NULL) = ADDRESSV);
                       assert ((WORDPTRV - WORDPTR2V) = NULL);

                       -- File types.
                       assert ((FILEV + FILEV) = FILEV);
                       assert ((FILEV - FILEV) = FILEV);

                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
