
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e5.54.th.le.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that the time expression in a disconnection
--                specification must be static.
--
--   Author(s) :  KES          
--
--   Notes     :  ARCHITECTURE FIRST.
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is
    -- Define res function for SIG:
    function RESFUNC( S : BIT_VECTOR ) return BIT is
    begin
        for I in S'RANGE loop
           if (S(I) = '1') then
              return '1'; 
           end if;
        end loop;
        return '0';
    end RESFUNC;

    -- Define the signal.
    subtype RBIT is RESFUNC BIT;
    signal SIG : RBIT bus;
    signal SIG2 : INTEGER := 10;

    -- ERROR:  Non-static delay.
    disconnect others : RBIT after (SIG2 * 1ns);

begin

end TEST_BEHAVIOR;
             



configuration BETA of TEST is

    for TEST_BEHAVIOR

    end for;

end BETA;
