
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e5.53.no.on.1.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that no guarded signal may be declared after a
--                disconnect specification which uses 'all'.
--
--   Author(s) :  KES          
--
--   Notes     :  ARCHITECTURE FIRST.
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is
    -- Define res function for SIG:
    function RESFUNC( S : BIT_VECTOR ) return BIT is
    begin
        for I in S'RANGE loop
           if (S(I) = '1') then
              return '1'; 
           end if;
        end loop;
        return '0';
    end RESFUNC;

    -- Define the signal.
    subtype RBIT is RESFUNC BIT;
    signal SIG : RBIT bus;

    -- This should be the last disconnect specification.
    disconnect all : RBIT after 10ns;

    -- ERROR:  Signal declaration after 'all'.
    signal SIG1 : RBIT bus;

begin

end TEST_BEHAVIOR;
