
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  v4.12.th.rk.1.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that two subtypes which have different base types
--                cannot be compared.
--
--   Author(s) :  KES          
--
--   Notes     :  
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is


begin
    TEST_PROCESS:  process
                      -- Define a subtype of a subtype.
                      subtype ZERO is NATURAL range 0 to 0;

                      -- Define a subtype of a different type.
                      type A is range 0 to 10;
                      subtype ASUB is A;

                      -- Define variables of these subtypes.
                      variable ZEROV     : ZERO := 0;
                      variable AV        : ASUB := 0;

                   begin
                       -- Should not be legal to compare these two types.  ERROR:
                       assert( ZEROV = AV );

                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
