-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  rgrce.02.029.if.am.001.vhdl
--   Title     :  IEEE Std 1076-1987 Language Reference Manual test
--
--   Purpose   :  check subprogram identifier usage in the end statement
--                
--   Author(s) :  EIS Modeling, Inc.          
--
--   Notes     :  "If a designator appears at the end of a subprogram body,
--                 it must repeat the designator of the subprogram."
----------------------------------------------------------------------------
--
Entity EIS is
  port(A:in bit);

  function func1 (A:bit) return boolean is
    variable B: bit:='1';
  begin
    if A = B then return TRUE;
    else return FALSE;
    end if;
  -- ERROR: label must be the same as subprogram identifier
  end func;

  procedure proc1 (A:bit; B: out boolean) is
  begin
    if A = '1' then B := TRUE;
    else B := FALSE;
    end if;
  -- ERROR: label must be the same as subprogram identifier
  end proc;
end EIS;
